"use strict";
this.name = "SuperSystem";
this.author = "phkb";
this.copyright = "2024 phkb";
this.description = "Creates custom surface locations using PlanetFall2";
this.license = "CC-BY-SA-NC 4.0";

this.startUp = function() {
    var pf = worldScripts.PlanetFall2;
    pf._landingImages["distCentre"] = ["planetFall2_dist1.png", "planetFall2_dist2.png", "planetFall2_dist3.png"];
    pf._locationOverrides["0 131"] = {
        main: [
            {
                roles: ["capitalCity", "capitalCity", "leisureComplex", "factory"],
                names: ["Upper Wilmot (Capital City)", "Lower Wilmot (City)", "Soho (Leisure Centre)", "Bob's Place (Automobile Factory)"],
            },
        ],
	planet: [
	    {
		roles: ["colony", "militaryBase", "factory"],
		names: ["Newcastle (Colony City)", "HIMSN Albatross (Military Base)", "Pete's Place (Zero-G Cricket Factory)"],
	    },
	    {
		roles: ["colony", "leisureComplex", "dump"],
		names: ["Maitland (Colony City)", "Gold Coast (Leisure Centre)", "Lithgow Outskirts (Rubbish Dump)"],
	    },
	],
	moon: [
	    {
		roles: ["colonyDome", "mine", "prison"],
		names: ["Fairfield (Colony Dome)", "New Haven (Mine)", "Pentridge (Prison)"],
	    },
	],
    };
    pf._locationOverrides["0 62"] = {
        main: [
            {
                roles: ["capitalCity", "capitalCity", "leisureComplex", "planetFall2_mainSurface_distributionCentre"],
                names: ["Penrith (Capital City)", "Kingswood (City)", "Boni Beach (Leisure Centre)", "Paddington Markets (Distribution Centre)"],
            },
        ], 
    };
}

this.$namingCricketStadiums = function(dataKey) {
    var names = ["Accor Stadium", "Lord's Cricket Ground", "Melbourne Cricket Ground", "Edgbaston Cricket Ground", "Sydney Cricket Ground"];
    var selected = Math.floor(system.scrambledPseudoRandomNumber(1123) * 5);
    return names[selected];
}